
/* ********************************************************

Bailey MLH

   usage info: bailey_mlh -h

******************************************************** */


#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>
#include <math.h>

#include <unistd.h>

#include "cbt_evd.h"
#include "cbt_util.h"

#define VERSION "$Id: bailey_mlh.c,v 1.18 2003/08/20 22:03:42 gec Exp $"

#define MAX_LINE_LENGTH (1024)
#define MAX_DATA (100000)


#define FALSE (0)
#define TRUE (1)


void help(void) {
  //FIXME
}

/* Read data from data file using res_stats format*/
void read_data(FILE *fin, 
               size_t   max_n,
               size_t * N,
               long int * query_length,
               long int * scores, 
               long int * lengths) 
{
  char buffer[MAX_LINE_LENGTH];
  char id[MAX_LINE_LENGTH];
  size_t n= 0;

  // First line 
  // query_length > query_id
  if(NULL==fgets(buffer, MAX_LINE_LENGTH, fin))
    cbt_die("Cannot read data");

  if( EOF==sscanf(buffer, "%ld", query_length) ) 
      cbt_die("Error reading data ");

  while(fgets(buffer, MAX_LINE_LENGTH, fin)!=NULL) {
    if( EOF==sscanf(buffer, "%s 0 %ld 0 -1.00000 -1.00000 %ld 0 0 999",
                    id, &(lengths[n]), &(scores[n]) ) ) {
      cbt_die("Error reading data ");
    }
    n++;
    if(n > max_n) cbt_die("Too much data!");
  }
  *N = n;
}

int main(int argc, char *argv[]) {
  int c;

  FILE * fin = stdin;
  FILE * fout = stdout;

  int error_flag;
  long int query_length;
  size_t n,i;
  long int  * scores;
  long int  * lengths;

  double lambda;
  double K;
  double H;
  double * e_values;
  int verbose = FALSE;

  scores = calloc(MAX_DATA, sizeof(long int));
  lengths = calloc(MAX_DATA, sizeof(long int));
  e_values = calloc(MAX_DATA, sizeof(double));


  while ((c = getopt (argc, argv, "i:o:r:hvqBF")) != -1) {
    switch (c) {
    case 'i' :
      fin = fopen(optarg, "r");
      if(fin == NULL) cbt_die("Cannot open file %s for input.", optarg);
      break;
    case 'o' :
      fout = fopen(optarg, "w"); 
      if(fout == NULL) cbt_die("Cannot open file %s for output.", optarg);
      break;
    case 'h' :
      help();
      break;
    case 'v' : 
      verbose = TRUE;
      break;
    default :
      cbt_die("Internal argument parsing error");
    }
  }


  read_data(fin, MAX_DATA, &n, &query_length, scores, lengths);

  if(verbose) {
    fprintf(fout, "n: %ld\n", n);
    fprintf(fout, "query length: %ld\n", query_length);
    fprintf(fout, "scores, lengths\n");
    for(i =0; i<n; i++) {
      //fprintf(fout, "%ld %ld\n",scores[i],lengths[i]);
      fprintf(fout, "%ld, ",lengths[i]);
    }
    fflush(fout);
  }
 

  error_flag = cbt_evd(n, scores, lengths, query_length,
                        &lambda, &K, &H, e_values);

  if(error_flag) cbt_die("e_values failed");

  fprintf(fout, "%g %g %g", lambda, K, H);
  for ( i = 0; i < n; i++ ) {
    if ( e_values[ i ] <= CBT_E_VALUE_CUTOFF ) {
      fprintf( fout, "\n%d %g", (int) i, e_values[ i ] );
    }
  }
  fprintf( fout, "\n" );
  
  return 0; // Done
}


























